<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once 'includes/auth.php';
$pdo = getDBConnection();

// Get all tasks with audio
$stmt = $pdo->query("
    SELECT id, instruction_text, sample_audio_url, status 
    FROM tasks 
    WHERE is_mini_task = 1 
    ORDER BY id
");
$tasks = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
    <title>Audio Debug</title>
    <style>
        body { font-family: system-ui; padding: 20px; background: #f5f5f5; }
        .container { max-width: 1000px; margin: 0 auto; background: white; padding: 30px; border-radius: 8px; }
        table { width: 100%; border-collapse: collapse; margin: 20px 0; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #e2e8f0; }
        th { background: #f7fafc; font-weight: 600; }
        .success { color: #10b981; font-weight: bold; }
        .error { color: #ef4444; font-weight: bold; }
        .warning { color: #f59e0b; font-weight: bold; }
        code { background: #f1f5f9; padding: 2px 6px; border-radius: 4px; font-family: monospace; font-size: 0.9em; }
        audio { width: 100%; max-width: 300px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🎵 Audio Files Debug</h1>
        
        <h2>Tasks in Database</h2>
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Instruction</th>
                    <th>Audio URL (DB)</th>
                    <th>File Exists?</th>
                    <th>Player</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($tasks as $task): ?>
                    <tr>
                        <td><strong><?php echo $task['id']; ?></strong></td>
                        <td style="max-width: 300px;"><?php echo htmlspecialchars(substr($task['instruction_text'], 0, 80)); ?>...</td>
                        <td>
                            <?php if (!empty($task['sample_audio_url'])): ?>
                                <code><?php echo htmlspecialchars($task['sample_audio_url']); ?></code>
                            <?php else: ?>
                                <span class="warning">⚠ No audio</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <?php 
                            if (!empty($task['sample_audio_url'])) {
                                $audioUrl = $task['sample_audio_url'];
                                
                                // Try different path variations
                                $possiblePaths = [
                                    __DIR__ . '/' . ltrim($audioUrl, '/'),
                                    __DIR__ . '/uploads/' . basename($audioUrl),
                                    __DIR__ . '/' . str_replace('/uploads/', 'uploads/', $audioUrl),
                                ];
                                
                                $found = false;
                                $foundPath = '';
                                foreach ($possiblePaths as $path) {
                                    if (file_exists($path)) {
                                        $found = true;
                                        $foundPath = $path;
                                        break;
                                    }
                                }
                                
                                if ($found) {
                                    echo '<span class="success">✓ Found</span><br>';
                                    echo '<small style="color: #666;">' . htmlspecialchars($foundPath) . '</small>';
                                } else {
                                    echo '<span class="error">✗ Not found</span><br>';
                                    echo '<small style="color: #666;">Tried:<br>';
                                    foreach ($possiblePaths as $p) {
                                        echo '• ' . htmlspecialchars($p) . '<br>';
                                    }
                                    echo '</small>';
                                }
                            } else {
                                echo '-';
                            }
                            ?>
                        </td>
                        <td>
                            <?php if (!empty($task['sample_audio_url'])): ?>
                                <audio controls>
                                    <source src="<?php echo htmlspecialchars($task['sample_audio_url']); ?>" type="audio/mpeg">
                                    Your browser does not support the audio element.
                                </audio>
                            <?php else: ?>
                                -
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        
        <h2>Files in uploads/ Directory</h2>
        <?php
        $uploadDir = __DIR__ . '/uploads/';
        if (is_dir($uploadDir)) {
            $files = array_diff(scandir($uploadDir), ['.', '..']);
            if (!empty($files)) {
                echo '<ul>';
                foreach ($files as $file) {
                    $fullPath = $uploadDir . $file;
                    if (is_file($fullPath)) {
                        echo '<li><code>' . htmlspecialchars($file) . '</code> (' . filesize($fullPath) . ' bytes)</li>';
                    }
                }
                echo '</ul>';
            } else {
                echo '<p>No files found in uploads directory.</p>';
            }
        } else {
            echo '<p class="error">Uploads directory does not exist!</p>';
        }
        ?>
        
        <div style="margin-top: 30px; padding-top: 20px; border-top: 2px solid #e2e8f0;">
            <a href="chat.php" style="color: #4a90e2; text-decoration: none; font-weight: 600;">← Back to Chat</a> |
            <a href="admin/mini_task_manager.php" style="color: #4a90e2; text-decoration: none; font-weight: 600;">Admin Panel →</a>
        </div>
    </div>
</body>
</html>
