<?php
session_start();
require_once __DIR__ . '/includes/auth_check.php';
require_once __DIR__ . '/includes/db_connect.php';

// Check if admin is logged in
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit();
}

$success = '';
$error = '';

// Handle database clear action
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'clear_database') {
    if (!isset($_POST['confirm']) || $_POST['confirm'] !== 'yes') {
        $error = 'Please confirm you want to clear the database.';
    } else {
        try {
            $pdo->beginTransaction();
            
            // Disable foreign key checks temporarily
            $pdo->exec('SET FOREIGN_KEY_CHECKS = 0');
            
            // Get all tables
            $tables = $pdo->query('SHOW TABLES')->fetchAll(PDO::FETCH_COLUMN);
            
            // Exclude tables you want to keep (if any)
            $tablesToKeep = ['migrations', 'config', 'users'];
            $tables = array_diff($tables, $tablesToKeep);
            
            foreach ($tables as $table) {
                // Skip views
                $stmt = $pdo->query("SHOW TABLE STATUS LIKE '$table'");
                $tableInfo = $stmt->fetch(PDO::FETCH_ASSOC);
                
                if ($tableInfo['Comment'] !== 'VIEW') {
                    $pdo->exec("TRUNCATE TABLE `$table`");
                    $pdo->exec("ALTER TABLE `$table` AUTO_INCREMENT = 1");
                }
            }
            
            // Re-enable foreign key checks
            $pdo->exec('SET FOREIGN_KEY_CHECKS = 1');
            
            $pdo->commit();
            $success = 'Database has been cleared successfully!';
            
        } catch (PDOException $e) {
            $pdo->rollBack();
            $error = 'Error clearing database: ' . $e->getMessage();
            error_log("Database clear error: " . $e->getMessage());
        }
    }
}

$pageTitle = 'Settings';
include 'includes/header.php';
?>

<div class="container mx-auto px-4 py-8">
    <div class="flex justify-between items-center mb-8">
        <h1 class="text-2xl font-bold text-gray-800">Settings</h1>
    </div>

    <?php if ($success): ?>
        <div class="mb-6 p-4 bg-green-100 border border-green-400 text-green-700 rounded">
            <?php echo $success; ?>
        </div>
    <?php endif; ?>
    
    <?php if ($error): ?>
        <div class="mb-6 p-4 bg-red-100 border border-red-400 text-red-700 rounded">
            <?php echo $error; ?>
        </div>
    <?php endif; ?>

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="p-6">
            <h2 class="text-xl font-semibold text-gray-800 mb-6">Database Tools</h2>
            
            <div class="border border-red-200 rounded-lg p-6 bg-red-50">
                <h3 class="text-lg font-medium text-red-800 mb-3">Danger Zone</h3>
                <p class="text-red-700 mb-4">
                    These actions are irreversible. Please make sure you have a backup before proceeding.
                </p>
                
                <form method="post" onsubmit="return confirm('⚠️ WARNING: This will delete all data in the database. Are you absolutely sure?');">
                    <input type="hidden" name="action" value="clear_database">
                    <input type="hidden" name="confirm" value="yes">
                    
                    <div class="flex items-center justify-between">
                        <div>
                            <h4 class="font-medium text-gray-900">Clear Database</h4>
                            <p class="text-sm text-gray-600">
                                Permanently delete all data from all tables (except users and essential system tables).
                            </p>
                        </div>
                        <button type="submit" class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700 focus:outline-none focus:ring-2 focus:ring-red-500 focus:ring-offset-2">
                            Clear Database
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
