<?php
/**
 * Permission Fix Script
 * This will attempt to create the uploads directory with proper permissions
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

$baseDir = __DIR__ . '/../uploads/';
$results = [];

// Create main uploads directory
if (!file_exists($baseDir)) {
    if (@mkdir($baseDir, 0777, true)) {
        $results[] = ['success' => true, 'msg' => "Created uploads directory"];
        @chmod($baseDir, 0777);
    } else {
        $results[] = ['success' => false, 'msg' => "Failed to create uploads directory"];
    }
} else {
    $results[] = ['success' => true, 'msg' => "Uploads directory already exists"];
    // Try to fix permissions
    if (@chmod($baseDir, 0777)) {
        $results[] = ['success' => true, 'msg' => "Fixed permissions on uploads directory"];
    } else {
        $results[] = ['success' => false, 'msg' => "Could not change permissions (may need terminal)"];
    }
}

// Check if writable
if (is_writable($baseDir)) {
    $results[] = ['success' => true, 'msg' => "Uploads directory is writable ✓"];
} else {
    $results[] = ['success' => false, 'msg' => "Uploads directory is NOT writable"];
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Fix Permissions</title>
    <style>
        body { font-family: system-ui; padding: 20px; background: #f5f5f5; }
        .container { max-width: 700px; margin: 0 auto; background: white; padding: 30px; border-radius: 8px; }
        .result { padding: 12px; margin: 10px 0; border-radius: 6px; border-left: 4px solid; }
        .success { background: #d1fae5; border-color: #10b981; color: #065f46; }
        .error { background: #fee2e2; border-color: #ef4444; color: #991b1b; }
        .command { background: #1e293b; color: #e2e8f0; padding: 15px; border-radius: 6px; margin: 15px 0; font-family: monospace; }
        .btn { display: inline-block; padding: 10px 20px; background: #4a90e2; color: white; text-decoration: none; border-radius: 6px; margin-top: 20px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🔧 Permission Fix Results</h1>
        
        <?php foreach ($results as $result): ?>
            <div class="result <?php echo $result['success'] ? 'success' : 'error'; ?>">
                <?php echo $result['success'] ? '✓' : '✗'; ?> <?php echo htmlspecialchars($result['msg']); ?>
            </div>
        <?php endforeach; ?>
        
        <?php if (!is_writable($baseDir)): ?>
            <h2>Manual Fix Required</h2>
            <p>The web server doesn't have permission to change directory permissions. Run this command in your terminal:</p>
            <div class="command">cd /Applications/XAMPP/xamppfiles/htdocs/vonaida<br>sudo chmod -R 777 uploads</div>
            <p>Then click the button below to verify:</p>
            <a href="fix_permissions.php" class="btn">🔄 Check Again</a>
        <?php else: ?>
            <h2>✅ All Good!</h2>
            <p>The uploads directory is now writable. You can now upload audio files.</p>
        <?php endif; ?>
        
        <a href="mini_task_manager.php" class="btn">← Back to Mini Task Manager</a>
    </div>
</body>
</html>
