// This file should only be loaded as an AudioWorklet
if (typeof AudioWorkletGlobalScope !== 'undefined') {
  // We're in the AudioWorkletGlobalScope
  class AudioRecorderProcessor extends AudioWorkletProcessor {
    constructor() {
      super();
      this.port.onmessage = (e) => {
        // Handle messages from the main thread if needed
      };
    }

    process(inputs) {
      const input = inputs[0];
      if (input && input.length > 0) {
        const channelData = input[0];
        const bufferCopy = new Float32Array(channelData.length);
        for (let i = 0; i < channelData.length; i++) {
          bufferCopy[i] = channelData[i];
        }
        this.port.postMessage({ audioData: bufferCopy });
      }
      return true;
    }
  }

  registerProcessor('audio-recorder-processor', AudioRecorderProcessor);
}
