<?php
session_start();
require_once __DIR__ . '/includes/auth_check.php';
require_once __DIR__ . '/includes/db_connect.php';

// export approved recordings metadata as CSV
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="approved_recordings.csv"');
$out = fopen('php://output','w');
fputcsv($out, ['id','filename','user_id','duration','sample_rate','channels','task_id','created_at']);

$stmt = $pdo->prepare("SELECT id, filename, user_id, duration, sample_rate, channels, task_id, created_at FROM recordings WHERE status='approved' ORDER BY created_at ASC");
$stmt->execute();
while($row = $stmt->fetch(PDO::FETCH_ASSOC)){
    fputcsv($out, $row);
}
fclose($out);
exit;
